#ifndef PIECE_H
#define PIECE_H

#include "defs.h"

#include <cstring>

using namespace std;

const uint pE = 0;
const uint pwP = 1;
const uint pwN = 3;
const uint pwB = 5;
const uint pwR = 7;
const uint pwQ = 9;
const uint pwK = 11;

const uint pbP = 2;
const uint pbN = 4;
const uint pbB = 6;
const uint pbR = 8;
const uint pbQ = 10;
const uint pbK = 12;

const uint cW = 0;
const uint cB = 1;
const uint cN = 2;

const uint numpieces = 13;//includes "empty uint"
const uint numcolours = 2;
const uint maxpiecenum = 11; //max numer of one type - technically could have 9 queens.... plus piece list space [0] is free
const uint piecedead = 0;

extern int	const dirN[];
extern int	const dirB[];
extern int	const dirR[];
extern int	const dirQ[];
extern int const *dirPieces[];

extern int	const dirwP[];
extern int	const dirbP[];
extern int const *dirPawn[];

extern uint const epdelta[2];

extern const string piecechars;
extern const string colourchars;

extern uint ismajor[numpieces];
extern uint isminor[numpieces];
extern uint isbigpiece[numpieces]; //N or above
extern uint iswhite[numpieces];
extern uint isblack[numpieces];
extern uint isslide[numpieces];
extern uint iscolour[numpieces];

extern const uint sliders[numcolours][3];
extern const uint nonsliders[numcolours][2];
extern const uint pawns[numcolours];
extern const uint kings[numcolours];
extern const uint startrank[numcolours];

inline bool piecegood(const uint p) { return (p>=pE && p<=pbK); }
inline bool colourgood(const uint c) { return (c>=cW && c<=cN); }
inline bool slides(const uint p) { return (isslide[p]==1); }
inline bool blackpce(const uint p) { return (isblack[p]==1); }
inline bool whitepce(const uint p) { return (iswhite[p]==1); }
inline uint pcecolour(const uint p) { return iscolour[p]; }

extern void init_piece_matrices();
extern char piecechar(const uint p);
extern char colourchar(const uint c);

#endif
